using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        string[] first = Console.ReadLine().Split();
        int N = int.Parse(first[0]);
        long W = long.Parse(first[1]);
        double eps = double.Parse(first[2]);

        long[] w = new long[N];
        long[] v = new long[N];

        long vmax = 0;

        for (int i = 0; i < N; i++)
        {
            string[] line = Console.ReadLine().Split();
            w[i] = long.Parse(line[0]);
            v[i] = long.Parse(line[1]);
            if (v[i] > vmax) vmax = v[i];
        }

        double K = eps * vmax / N;
        if (K < 1) K = 1; 

        int[] vs = new int[N];
        int sumV = 0;

        for (int i = 0; i < N; i++)
        {
            vs[i] = (int)(v[i] / K);
            sumV += vs[i];
        }

        long INF = long.MaxValue / 4;
        long[] dp = new long[sumV + 1];
        int[,] from = new int[N + 1, sumV + 1];

        for (int i = 1; i <= sumV; i++)
            dp[i] = INF;

        dp[0] = 0;

        for (int i = 0; i < N; i++)
        {
            for (int val = sumV; val >= vs[i]; val--)
            {
                if (dp[val - vs[i]] + w[i] < dp[val])
                {
                    dp[val] = dp[val - vs[i]] + w[i];
                    from[i + 1, val] = 1;
                }
            }
        }

        int bestVal = 0;
        for (int i = 0; i <= sumV; i++)
        {
            if (dp[i] <= W)
                bestVal = i;
        }

        List<int> chosen = new List<int>();
        int curVal = bestVal;

        for (int i = N; i >= 1; i--)
        {
            if (from[i, curVal] == 1)
            {
                chosen.Add(i);
                curVal -= vs[i - 1];
            }
        }

        chosen.Reverse();

        Console.WriteLine(chosen.Count);
        for (int i = 0; i < chosen.Count; i++)
        {
            Console.Write(chosen[i]);
            if (i + 1 < chosen.Count) Console.Write(" ");
        }
        Console.WriteLine();
    }
}